<?php 
include("includes/db_helper.php");
include("includes/lb_helper.php"); 
include("language/api_language.php"); 

$file_path = getBaseUrl();

$mysqli->set_charset('utf8mb4');

$remote_addr = $_SERVER['REMOTE_ADDR'];
$user_agent = trim($_SERVER['HTTP_USER_AGENT']);

if (isset($_SERVER['HTTP_ORIGIN'])) {
    header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
}
header('Content-Type: application/json');

$jsonData = json_decode(file_get_contents('php://input'), true);
if (!is_array($jsonData)) { $jsonData = []; }

$action = isset($jsonData['action']) ? trim($jsonData['action']) : 'app_details'; // valor por defecto

// ====== UTILIDADES GENERALES ======
function ok($payload) {
    outputJson($payload); // asume que ya formatea como JSON y hace exit si usas die() después
}
function fail($message = "Solicitud inválida", $code = 400) {
    http_response_code($code);
    echo json_encode(["status" => "error", "message" => $message], JSON_UNESCAPED_UNICODE);
    die();
}
// ==================================

// RUTEO SIN TOKEN, POR ACCIÓN
switch ($action) {

    // 1) DETALLES DE LA APP + SERVIDORES
    case 'app_details':
    default: {
        $jsonObj = array();
        $data_arr = array();

        // Obtener el cliente de la URL
        $cliente = isset($_GET['cliente']) ? $_GET['cliente'] : ''; // Obtener el cliente de la URL

        if (empty($cliente)) {
            fail("Cliente no especificado.", 400);  // Si el cliente no se pasa en la URL, respondemos con un error
        }

        // App details (solo datos relevantes para ese cliente)
        // Filtramos por el cliente en la tabla tbl_app
        $sql = "SELECT * FROM tbl_app WHERE cliente='$cliente'";  // Filtramos por cliente
        $result = mysqli_query($mysqli, $sql) or die(mysqli_error($mysqli));
        while ($data = mysqli_fetch_assoc($result)) {
            $data_arr['app_name']         = $data['app_name'];
            $data_arr['app_titulo']       = $data['app_titulo'];
            $data_arr['app_logo']         = $file_path . "images/" . $data['app_logo'];
            $data_arr['bg_main']          = !empty($data['bg_main'])    ? $file_path . "images/" . $data['bg_main']    : "";
            $data_arr['bg_login']         = !empty($data['bg_login'])   ? $file_path . "images/" . $data['bg_login']   : "";
            $data_arr['bg_banner']        = !empty($data['bg_banner'])  ? $file_path . "images/" . $data['bg_banner']  : "";
        }
        mysqli_free_result($result);

        // Combine app details first
        $jsonObj['bienvenida']     = $data_arr['app_name'];
        $jsonObj['titulo']         = $data_arr['app_titulo'];
        $jsonObj['logo']           = $data_arr['app_logo'];
        $jsonObj['fondo']          = $data_arr['bg_main'];

        // Filtrar los servidores por el cliente
        $jsonObj['servidores'] = array();
        $sql = "SELECT * FROM tbl_dns WHERE status='1' AND cliente='$cliente' ORDER BY id DESC"; // Filtrar por cliente
        $result = mysqli_query($mysqli, $sql) or die(mysqli_error($mysqli));
        if (mysqli_num_rows($result) > 0) {
            while ($data2 = mysqli_fetch_assoc($result)) {
                $servidor = array();
                $servidor['title']       = $data2['dns_title'];
                $servidor['hdPosterUrl'] = $data2['dns_base'];
                array_push($jsonObj['servidores'], $servidor);
            }
        }
        mysqli_free_result($result);

        // Agregar LogoLogin y LogoMenu al final
        $jsonObj['LogoMenu']       = $data_arr['bg_banner'];
        $jsonObj['LogoLogin']      = $data_arr['bg_login'];

        // Evitar los corchetes y llaves extra
        echo json_encode($jsonObj, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        die();
    }
    
    case 'deeplink': {
        $user = "deeplink";
        $pass = "deeplink";

        $u = $jsonData['username'] ?? '';
        $p = $jsonData['password'] ?? '';

        if ($u === $user && $p === $pass) {
            ok(["status"=>"success","error"=>"Login success"]);
        } else {
            ok(["status"=>"error","error"=>"Invalid Login"]);
        }
        die();
    }
}

// Si llegó aquí, acción no válida
fail("Acción no reconocida. Usa 'action' = app_details | post_report | get_poster | deeplink", 404);    
